<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Konsultan;
use DB;
class KonsultanController extends Controller
{
    public function index()
    {
        return view('konsultan.index');
    }
    public function data()
    {
        $konsultan = Konsultan::all();    

        return datatables()
            ->of($konsultan)
            ->addIndexColumn()
            ->addColumn('kode', function ($konsultan) {
                return '<span class="label label-primary">'. $konsultan->kode .'</span>';
            })
            ->addColumn('aksi', function ($konsultan) {
                return '
                <div class="btn-group">
                    <a href="'. route('konsultan.afiliansi', $konsultan->id) .'" class="btn btn-xs btn-info btn-flat"><i class="fas fa-users"></i></a>
                    <button type="button" onclick="editForm(`'. route('konsultan.update', $konsultan->id) .'`)" class="btn btn-xs btn-info btn-flat"><i class="fas fa-pencil-alt"></i></button>
                    <button type="button" onclick="deleteData(`'. route('konsultan.destroy', $konsultan->id) .'`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
                </div>
                ';
            })
            ->rawColumns(['aksi', 'kode', 'select_all'])
            ->make(true);
    }
    public function store(Request $request)
    {
        // $harga_jual = preg_replace('/[^0-9]/', '', $request->get('harga_jual'));
        $produk_kode = Konsultan::latest()->first() ?? new Konsultan();
        
        
        
        $konsultan = new Konsultan();
        $konsultan->kode = $request->kode;
        $konsultan->nama = $request->nama;
        $konsultan->gender = $request->gender;
        $konsultan->alamat = $request->alamat;
        $konsultan->telp = $request->telp;
        $konsultan->email = $request->email;
        $konsultan->usia = $request->usia;
        $konsultan->catatan = $request->catatan;
        $konsultan->save();

        return response()->json('Data berhasil disimpan', 200);
    }
    public function show($id)
    {
        $konsultan = Konsultan::find($id);

        return response()->json($konsultan);
    }
    public function afiliansi($id)
    {
        // $konsultan = Konsultan::find($id);
        $afiliansi = DB::table('konsultan')
        ->leftjoin('membership', 'membership.id_konsultan', '=', 'konsultan.id')
        ->leftjoin('data_member', 'membership.id_member', '=', 'data_member.id')
         ->select('membership.*','konsultan.nama','konsultan.id','data_member.nama as nama_member','membership.tgl_masuk as tanggal_membership')
         ->where('membership.id_konsultan',$id)
         ->get();
        //  dd($afiliansi);
        return view('konsultan.afiliansi',compact('afiliansi'));
    }
   
    public function update(Request $request, $id)
    {
       
        $konsultan = Konsultan::find($id);
        $konsultan->kode = $request->kode;
        $konsultan->nama = $request->nama;
        $konsultan->gender = $request->gender;
        $konsultan->alamat = $request->alamat;
        $konsultan->telp = $request->telp;
        $konsultan->email = $request->email;
        $konsultan->usia = $request->usia;
        $konsultan->catatan = $request->catatan;
        $konsultan->update();

        return response()->json('Data berhasil disimpan', 200);
    }
    public function destroy($id)
    {
        $konsultan = Konsultan::find($id);
        $konsultan->delete();

        return response(null, 204);
    }
}
