<?php

namespace App\Http\Controllers;

use App\Models\Pembelian;
use App\Models\Pengeluaran;
use App\Models\Penjualan;
use App\Models\TotalKeseluruhan;
use App\Models\PembelianGym;
use App\Models\PenjualanDetail;
use Illuminate\Http\Request;
use PDF;
use DB;
use Carbon\Carbon;
class LaporanOmzetController extends Controller
{
   public function index()
   {
    return view('laporan_omzet.index');
   }

   public function data()
   {
    $produk = TotalKeseluruhan::select(DB::raw('SUM(total) as total_seluruh'),'total_keseluruhan.created_at as tanggal')
        ->selectRaw('YEAR(created_at) as year, MONTH(created_at) as month')
        // ->select('total_keseluruhan.created_at')
      ->get();
        // dd($produk);
    return datatables()
        ->of($produk)
        ->addIndexColumn()
        ->addColumn('select_all', function ($produk) {
            return '
                <input type="checkbox" name="id_produk[]" value="'. $produk->id_produk .'">
            ';
        })
        ->addColumn('tanggal', function ($produk) {
            return tanggal_inggris($produk->tanggal, false);
        })
        ->addColumn('kode_produk', function ($produk) {
            return '<span class="label label-primary">'. $produk->kode_produk .'</span>';
        })
        ->addColumn('total_seluruh', function ($produk) {
            return 'Rp.'.format_uang($produk->total_seluruh);
        })
        ->addColumn('gabung', function ($produk) {
            return $produk->month ."-". $produk->year;
        })
        ->rawColumns(['aksi', 'kode_produk', 'select_all','gabung','tanggal'])
        ->make(true);
}
}
