<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Pegawai;
class PegawaiController extends Controller
{
     /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $kategori = Kategori::all()->pluck('nama_kategori', 'id_kategori');

        return view('pegawai.index');
    }

    public function data()
    {
        $pegawai = Pegawai::all();   

        return datatables()
            ->of($pegawai)
            ->addIndexColumn()
            ->addColumn('select_all', function ($pegawai) {
                return '
                    <input type="checkbox" name="id_pegawai[]" value="'. $pegawai->id_pegawai .'">
                ';
            })
            ->addColumn('kode_pegawai', function ($pegawai) {
                return '<span class="label label-success">'. $pegawai->kode_pegawai.'</span>';
            })
           
            ->addColumn('aksi', function ($pegawai) {
                return '
                <div class="btn-group">
                    <button type="button" onclick="editForm(`'. route('pegawai.update', $pegawai->id_pegawai) .'`)" class="btn btn-xs btn-info btn-flat"><i class="fas fa-pencil-alt"></i></button>
                    <button type="button" onclick="deleteData(`'. route('pegawai.destroy', $pegawai->id_pegawai) .'`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
                </div>
                ';
            })
            ->rawColumns(['aksi', 'kode_pegawai', 'select_all'])
            ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // $paket = Paket::latest()->first() ?? new Paket();
        // $request['kode_paket'] = 'P'. tambah_nol_didepan((int)$paket->id +1, 6);

        $pegawai = Pegawai::create($request->all());

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $pegawai = Pegawai::find($id);

        return response()->json($pegawai);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $pegawai = Pegawai::find($id);
        $pegawai->update($request->all());

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $pegawai = Pegawai::find($id);
        $pegawai->delete();

        return response(null, 204);
    }

   

  
}
