<?php

use App\Http\Controllers\{
    DashboardController,
    KategoriController,
    LaporanController,
    LaporanAuthController,
    LaporanOmzetController,
    ProdukController,
    MemberController,
    PengeluaranController,
    PembelianController,
    PembelianDetailController,
    PenjualanController,
    PenjualanDetailController,
    SettingController,
    SupplierController,
    UserController,
    MarketingController,
    LabarugiController,
    ServiceController,
    TransaksiServiceController,
    TransaksiServiceDetailController,
    InstrukturController,
    PaketController,
    PaketPersonalController,
    FeeController,
    FeesController,
    CheckinController,
    PersonalController,
    PembeliangymController,
    StaffController,
    CheckMemberController,
    InsCheckController,
    UtangController,
    CheckoutController,
    AbsenController,
    PegawaiController,
    BarcodeController,
    HadirController,
    KonsultanController,
    TargetController,
    
};
use Illuminate\Support\Facades\Route;
use Carbon\Carbon;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
});


// Route::group(['middleware' => 'auth'], function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/dashboard/data', [DashboardController::class, 'show'])->name('dashboard.show');
    Route::get('/dashboard/data/2', [DashboardController::class, 'show2'])->name('dashboard.show2');
    Route::get('/dashboard/data/3', [DashboardController::class, 'show3'])->name('dashboard.show3');
    Route::get('/dashboard/data/4', [DashboardController::class, 'show4'])->name('dashboard.show4');
    

    // Route::group(['middleware' => ''], function () {
    // absen staff
    Route::get('/absen_staff', [AbsenController::class, 'staff_index'])->name('staff_index');
    Route::get('/absen_staff/ambil', [AbsenController::class, 'ambil'])->name('ambil.staff_index');
    Route::get('/absen_staff/absen/{id}', [AbsenController::class, 'absen_id'])->name('staff.absen');
    Route::get('/absen_staff/absen/ambil_data/{id}', [AbsenController::class, 'absen_ambil'])->name('staff.data_absen');
    Route::get('/absen_staff/absen/tanggal/{id}', [AbsenController::class, 'date_range'])->name('tanggal.absen');
    Route::get('/absen_staff/absen/checkout/{id}', [AbsenController::class, 'staff_out'])->name('staff.out');



    Route::get('/absen_personal', [AbsenController::class, 'pt_index'])->name('personal_index');
    Route::get('/absen_personal/ambil', [AbsenController::class, 'ambil_personal'])->name('ambil.personal_index');
    Route::get('/absen_personal/absen/{id}', [AbsenController::class, 'absen_pt'])->name('personal.absen');
    Route::get('/absen_personal/absen/ambil_data/{id}', [AbsenController::class, 'absen_ambil_pt'])->name('personal.data_absen');
    Route::get('/absen_personal/absen/checkout/{id}', [AbsenController::class, 'personal_out'])->name('personal.out');








    Route::get('/absen_staff/data', [AbsenController::class, 'checkout'])->name('absen_staff_checkout.data');



    // end absen staff

    // absen member
  Route::get('/absen_member',[AbsenController::class, 'absen_member'])->name('absen_member.index');
  Route::get('/absen_member/data', [AbsenController::class, 'data_member'])->name('absen_member.data');
//   end absen member

// absen instruktur
  Route::get('/absen_instruktur',[AbsenController::class, 'absen_instruktur'])->name('absen_instruktur.index');
  Route::get('/absen_instruktur/absen/{id}', [AbsenController::class, 'absen_ins'])->name('instruktur.data_absen');
   Route::get('/absen_instruktur/data', [AbsenController::class, 'data_instruktur'])->name('absen_instruktur.data');
//   end instruktur

        Route::get('/pegawai/data', [PegawaiController::class, 'data'])->name('pegawai.data');
        Route::get('/pegawai/{id}', [PegawaiController::class, 'show'])->name('pegawai.show');
        Route::post('/pegawai/delete-selected', [PegawaiController::class, 'deleteSelected'])->name('pegawai.delete_selected');
        Route::post('/pegawai/cetak-barcode', [PegawaiController::class, 'cetakBarcode'])->name('pegawai.cetak_barcode');
        Route::resource('/pegawai', PegawaiController::class);


        Route::get('/PT',[CheckinController::class, 'PT'])->name('PT');
        Route::get('/PT/ambildata', [CheckinController::class, 'PT_ambildata'])->name('PT.ambil.data');
         Route::resource('/PT', CheckinController::class);

        // Route::get('/CM',[CheckinController::class, 'PT'])->name('PT');
        Route::get('/CM/ambildata', [CheckMemberController::class, 'CM_ambildata'])->name('CM.ambil.data');
        Route::resource('/CM', CheckMemberController::class);

        Route::get('/staff',[StaffController::class, 'staff'])->name('staff');
        Route::get('/staff/ambildata', [StaffController::class, 'staff_ambildata'])->name('staff.ambil.data');
        Route::resource('/staff', StaffController::class);
 
        Route::get('/target',[TargetController::class, 'target'])->name('target');
        Route::get('/target/data', [TargetController::class, 'data'])->name('target.data');
        Route::resource('/target', TargetController::class);
        
        
        Route::resource('/check_instruktur', InsCheckController::class);
        Route::get('/utang/ambildata', [UtangController::class, 'utang_ambildata'])->name('utang.ambil.data');
        Route::resource('/utang', UtangController::class);


         Route::get('/barcode', [BarcodeController::class, 'index'])->name('barcode.index');
         Route::get('/barcode/ambil_data/{id?}', [BarcodeController::class, 'ambildata'])->name('barcode.ambil_data');
        Route::post('/employees/getEmployees/',[BarcodeController::class, 'getEmployees'])->name('employees.getEmployees');

        Route::get('/checkout/pt',[CheckoutController::class, 'pt_index'])->name('checkout.pt');
        Route::get('/checkout/pt/data/{id}', [PersonalController::class, 'pt_data_absen'])->name('pt.data_absen');
        Route::post('/checkout/pt/store/', [CheckoutController::class, 'pt_store'])->name('checkout.pt_store');

        Route::get('/checkout/staff',[CheckoutController::class, 'staff_index_check'])->name('checkout.staff');
        // Route::get('/checkout/staff/data/{id}', [UserController::class, 'staff_data_absen'])->name('staff.data_absen');
        Route::post('/checkout/staff/store/', [CheckoutController::class, 'staff_store'])->name('checkout.staff_store');


        Route::get('/checkout/instruktur',[CheckoutController::class, 'instruktur_index'])->name('checkout.instruktur');
        Route::get('/checkout/instruktur/data/{id}', [InstrukturController::class, 'instruktur_data_absen'])->name('check_instruktur.data_absen');
        Route::post('/checkout/instruktur/store/', [CheckoutController::class, 'instruktur_store'])->name('checkout.instruktur_store');



        Route::get('/kategori/data', [KategoriController::class, 'data'])->name('kategori.data');
        Route::resource('/kategori', KategoriController::class);

        Route::get('/produk/data', [ProdukController::class, 'data'])->name('produk.data');
        Route::get('/produk/{id}', [ProdukController::class, 'show'])->name('produk.show');
        Route::post('/produk/delete-selected', [ProdukController::class, 'deleteSelected'])->name('produk.delete_selected');
        Route::post('/produk/cetak-barcode', [ProdukController::class, 'cetakBarcode'])->name('produk.cetak_barcode');
        Route::resource('/produk', ProdukController::class);

        Route::get('/konsultan/data', [KonsultanController::class, 'data'])->name('konsultan.data');
        Route::get('/konsultan/{id}', [KonsultanController::class, 'show'])->name('konsultan.show');
        Route::get('/konsultan/afiliasi/{id}', [KonsultanController::class, 'afiliansi'])->name('konsultan.afiliansi');
        Route::post('/konsultan/delete-selected', [KonsultanController::class, 'deleteSelected'])->name('konsultan.delete_selected');
        Route::post('/konsultan/cetak-barcode', [KonsultanController::class, 'cetakBarcode'])->name('konsultan.cetak_barcode');
        Route::get('/afiliasi/data/{id}', [KonsultanController::class, 'afiliansi_data'])->name('afiliansi.data');
        Route::resource('/konsultan', KonsultanController::class);

        Route::get('/pembeliangym/data', [PembeliangymController::class, 'data'])->name('pembeliangym.data');
        Route::get('/pembeliangym/{id}', [PembeliangymController::class, 'show'])->name('pembeliangym.show');
        // Route::post('/pembeliangym/delete-selected', [PembeliangymController::class, 'deleteSelected'])->name('pembeliangym.delete_selected');
        // Route::post('/pembeliangym/cetak-barcode', [PembeliangymController::class, 'cetakBarcode'])->name('pembeliangym.cetak_barcode');
        Route::resource('/pembeliangym', PembeliangymController::class);
        
        Route::get('/hadir/data', [HadirController::class, 'data'])->name('hadir.data');
        Route::get('/hadir/hadir', [HadirController::class, 'hadir_hadir'])->name('hadir.ambil_data');
        Route::resource('/hadir', HadirController::class);

        Route::get('/fee/data', [FeeController::class, 'data'])->name('fee.data');
        Route::get('/fee/ambildata', [FeeController::class, 'fee_ambilData'])->name('fee.ambil.data');
        // Route::get('/fee/{id}', [FeeController::class, 'show'])->name('fee.show');
        Route::post('/fee/delete-selected', [FeeController::class, 'deleteSelected'])->name('fee.delete_selected');
        // Route::post('/fee/cetak-barcode', [FeeController::class, 'cetakBarcode'])->name('fee.cetak_barcode');
        Route::resource('/fee', FeeController::class);

         Route::get('/fees/data', [FeesController::class, 'data'])->name('fees.data');
        Route::get('/fees/ambildata', [FeesController::class, 'fees_ambilData'])->name('fees.ambil.data');
        // Route::get('/fees/{id}', [FeesController::class, 'show'])->name('fees.show');
        Route::post('/fees/delete-selected', [FeesController::class, 'deleteSelected'])->name('fees.delete_selected');
        // Route::post('/fees/cetak-barcode', [FeesController::class, 'cetakBarcode'])->name('fees.cetak_barcode');
        Route::resource('/fees', FeesController::class);

        Route::get('/paket/data', [PaketController::class, 'data'])->name('paket.data');
        Route::get('/paket/{id}', [PaketController::class, 'show'])->name('paket.show');
        Route::post('/paket/delete-selected', [PaketController::class, 'deleteSelected'])->name('paket.delete_selected');
        Route::post('/paket/cetak-barcode', [PaketController::class, 'cetakBarcode'])->name('paket.cetak_barcode');
        Route::resource('/paket', PaketController::class);
        

        Route::get('/member/data', [MemberController::class, 'data'])->name('member.data');
        Route::get('/member/absen_personal/data/{id}', [MemberController::class, 'data_absen2'])->name('member.data_absen2');
        Route::post('/member/absen2/store/', [MemberController::class, 'store_absen2'])->name('member.store_absen2');
        Route::get('/member/absen/{id}', [MemberController::class, 'absen'])->name('member.absen');
        Route::post('/member/absen/store/', [MemberController::class, 'store_absen'])->name('member.store_absen');
        Route::get('/member/detail/{id}', [MemberController::class, 'show'])->name('member.detail');
        Route::post('/member/delete-selected', [MemberController::class, 'deleteSelected'])->name('member.delete_selected');
        Route::get('/member/ambildata', [MemberController::class, 'layanan_ambilData'])->name('layanan.ambil.data');
        Route::get('/member/ambildata2', [MemberController::class, 'layanan_ambilData2'])->name('layanan.ambil.data2');
        Route::post('/member/cetak-member', [MemberController::class, 'cetakMember'])->name('member.cetak_member');
        Route::get('/member/cetak_pdf/{id}', [MemberController::class, 'cetak2'])->name('member.cetak2');
        Route::get('/member/edit_profil/{id}', [MemberController::class, 'edit2'])->name('member.edit_profil');
        Route::get('/member/paket_personal_trainer/{id}', [MemberController::class, 'edit3'])->name('member.edit3');
        Route::get('/member/ganti_kartu/{id}', [MemberController::class, 'ganti_kartu'])->name('member.ganti_kartu');
        Route::get('/bismillah/{id}', [MemberController::class, 'ambil_member_paket'])->name('anu_paket.show');
        Route::put('/member/edit_profil/updated/{id}', [MemberController::class, 'updated_profil'])->name('member.updated_profil');
        Route::put('/member/detail/updated/{id}', [MemberController::class, 'updated_detail'])->name('member.updated_detail');
        Route::put('/member/paket/updated/{id}', [MemberController::class, 'updated_personal'])->name('member.updated_personal');
        Route::put('/member/ganti_kartu/updated/{id}', [MemberController::class, 'updated_kartu'])->name('member.updated_kartu');
        Route::get('/member/data_absen/{id}', [MemberController::class, 'data_absen'])->name('member.data_absen');
        // Route::get('/member/data_data_absen/{/id}', [MemberController::class, 'data_data_absen'])->name('member.data_data_absen');
        // Route::get('/member/cetak_pdf/{id}', [MemberController::class, 'cetak_pdf'])->name('member.cetak_pdf');
        Route::resource('/member', MemberController::class);

        Route::get('/supplier/data', [SupplierController::class, 'data'])->name('supplier.data');
        Route::resource('/supplier', SupplierController::class);

        Route::get('/instruktur/data', [InstrukturController::class, 'data'])->name('instruktur.data');
        Route::get('/instruktur/absen/{id}', [InstrukturController::class, 'absen'])->name('checkins.absen');
         Route::get('/instruktur/absen/data/{id}', [InstrukturController::class, 'data_absen'])->name('checkins.data_absen');
        Route::post('/instruktur/delete-selected', [InstrukturController::class, 'deleteSelected'])->name('instruktur.delete_selected');
        Route::resource('/instruktur', InstrukturController::class);

        Route::get('/personal/data', [PersonalController::class, 'data'])->name('personal.data');
        Route::get('/personal/afiliasi/{id}', [PersonalController::class, 'afiliansi'])->name('personal.afiliansi');
        Route::post('/personal/delete-selected', [PersonalController::class, 'deleteSelected'])->name('personal.delete_selected');
        Route::resource('/personal', PersonalController::class);


         Route::get('/paket_personal/data', [PaketPersonalController::class, 'data'])->name('paket_personal.data');
        Route::get('/paket_personal/{id}', [PaketPersonalController::class, 'show'])->name('paket_personal.show');
        Route::post('/paket_personal/delete-selected', [PaketPersonalController::class, 'deleteSelected'])->name('paket_personal.delete_selected');
        Route::post('/paket_personal/cetak-barcode', [PaketPersonalController::class, 'cetakBarcode'])->name('paket_personal.cetak_barcode');
        Route::resource('/paket_personal', PaketPersonalController::class);

        Route::get('/transaksiservice/data', [TransaksiServiceController::class, 'data'])->name('transaksiservice.data');
        Route::get('/transaksiservice/{id}/create', [TransaksiServiceController::class, 'create'])->name('transaksiservice.create');
        Route::resource('/transaksiservice', TransaksiServiceController::class)
            ->except('create');

        Route::get('/transaksiservice_detail/{id}/data', [TransaksiServiceDetailController::class, 'data'])->name('transaksiservice_detail.data');
        Route::get('/pembelian_detail/loadform/{diskon}/{total}', [TransaksiServiceDetailController::class, 'loadForm'])->name('transaksiservice_detail.load_form');
        Route::resource('/pembelian_detail', PembelianDetailController::class)
            ->except('create', 'show', 'edit');


        Route::get('/service/data', [ServiceController::class, 'data'])->name('service.data');
        Route::resource('/service', ServiceController::class);

        Route::get('/labarugi', [LabarugiController::class, 'index'])->name('labarugi.index');
        Route::get('/labarugi/create', [LabarugiController::class, 'create'])->name('labarugi.create');

      

        Route::get('/marketing/data', [MarketingController::class, 'data'])->name('marketing.data');
        Route::resource('/marketing', MarketingController::class);

        Route::get('/pengeluaran/data', [PengeluaranController::class, 'data'])->name('pengeluaran.data');
        Route::resource('/pengeluaran', PengeluaranController::class);

        Route::get('/pembelian/data', [PembelianController::class, 'data'])->name('pembelian.data');
        Route::get('/pembelian/{id}/create', [PembelianController::class, 'create'])->name('pembelian.create');
        Route::resource('/pembelian', PembelianController::class)
            ->except('create');

        Route::get('/pembelian_detail/{id}/data', [PembelianDetailController::class, 'data'])->name('pembelian_detail.data');
        Route::get('/pembelian_detail/loadform/{diskon}/{total}', [PembelianDetailController::class, 'loadForm'])->name('pembelian_detail.load_form');
        Route::resource('/pembelian_detail', PembelianDetailController::class)
            ->except('create', 'show', 'edit');

        Route::get('/penjualan/data', [PenjualanController::class, 'data'])->name('penjualan.data');
        Route::get('/penjualan', [PenjualanController::class, 'index'])->name('penjualan.index');
        Route::get('/penjualan/{id}', [PenjualanController::class, 'show'])->name('penjualan.show');
        Route::get('/penjualan/catatan/{id}', [PenjualanController::class, 'show2'])->name('catatan.show2');
        Route::delete('/penjualan/{id}', [PenjualanController::class, 'destroy'])->name('penjualan.destroy');
    // });

    
        Route::get('/transaksi/baru', [PenjualanController::class, 'create'])->name('transaksi.baru');
        Route::post('/transaksi/simpan', [PenjualanController::class, 'store'])->name('transaksi.simpan');
        Route::get('/transaksi/selesai', [PenjualanController::class, 'selesai'])->name('transaksi.selesai');
        Route::get('/transaksi/nota-kecil', [PenjualanController::class, 'notaKecil'])->name('transaksi.nota_kecil');
        Route::get('/transaksi/nota-besar', [PenjualanController::class, 'notaBesar'])->name('transaksi.nota_besar');

        Route::get('/transaksi/{id}/data', [PenjualanDetailController::class, 'data'])->name('transaksi.data');
        Route::get('/transaksi/loadform/{diskon}/{total}/{diterima}', [PenjualanDetailController::class, 'loadForm'])->name('transaksi.load_form');
        Route::resource('/transaksi', PenjualanDetailController::class)
            ->except('create', 'show', 'edit');
    // });


         Route::get('/laporan', [LaporanController::class, 'index'])->name('laporan.index');
        Route::get('/laporan/data/{awal}/{akhir}', [LaporanController::class, 'data'])->name('laporan.data');
        Route::get('/auth/pendapatan/', [LaporanController::class, 'detail_pendapatan'])->name('auth.pendapatan');
        Route::get('/laporan/pdf/{awal}/{akhir}', [LaporanController::class, 'exportPDF'])->name('laporan.export_pdf');


         Route::get('/laporan_omzet', [LaporanOmzetController::class, 'index'])->name('laporan_omzet.index');
        Route::get('/laporan_omzet/data/', [LaporanOmzetController::class, 'data'])->name('laporan_omzet.data');
        Route::get('/auth/pendapatan/', [LaporanOmzetController::class, 'detail_pendapatan'])->name('auth.pendapatan');
        Route::get('/laporan_omzet/pdf/{awal}/{akhir}', [LaporanOmzetController::class, 'exportPDF'])->name('laporan_omzet.export_pdf');


         Route::get('/shift', [LaporanAuthController::class, 'index2'])->name('shift.index');
          Route::get('/shift/hapus/{id}',[LaporanAuthController::class, 'hapus'])->name('shift.hapus');
         Route::get('/shift/cetak_pdf', [LaporanAuthController::class, 'cetak2'])->name('shift.cetak2');

         Route::get('/user/data', [UserController::class, 'data'])->name('user.data');
         Route::resource('/user', UserController::class);

        Route::get('/setting', [SettingController::class, 'index'])->name('setting.index');
        Route::get('/setting/first', [SettingController::class, 'show'])->name('setting.show');
        Route::post('/setting', [SettingController::class, 'update'])->name('setting.update');
    // });
 
    
        Route::get('/profil', [UserController::class, 'profil'])->name('user.profil');
        Route::post('/profil', [UserController::class, 'updateProfil'])->name('user.update_profil');
    // });

   
   
// });