<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use\App\Models\PembelianGym;
use Carbon\Carbon;
use Auth;
class PembeliangymController extends Controller
{
    public function index()
    {
        $today=Carbon::now()->format('d-m-Y');
        // dd($today);
        return view('pembeliangym.index',compact('today'));
    }

    public function data()
    {
        $pembelian = PembelianGym::orderBy('id', 'desc')->get();
        // dd($pembelian);
        return datatables()
            ->of($pembelian)
            ->addIndexColumn()
             ->addColumn('harga', function ($pembelian) {
                     return format_uang($pembelian->harga);
                 })
                  ->addColumn('total', function ($pembelian) {
                     return format_uang($pembelian->total);
                 })
            ->addColumn('aksi', function ($pembelian) {
                return '
                <div class="btn-group">
                    <button type="button" onclick="deleteData(`'. route('pembeliangym.destroy', $pembelian->id) .'`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
                </div>
                ';
            })
            ->rawColumns(['aksi','harga','total'])
            ->make(true);
    }
    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       
        $user = new PembelianGym();
        $user->tanggal = $request->tanggal;
        $user->nama_supplier = $request->nama_supplier;
        $user->nama_barang = $request->nama_barang;
        $user->qty = $request->qty;
        $user->harga = $request->harga;
        $user->total = $request->total;
        $user->type_pembayaran = $request->type_pembayaran;
        $user->catatan = $request->catatan;
        $user->id_user = Auth()->user()->name;
        $user->save();
// KODE OTOMATIS TAMBAHKAN SYNTAX DISINI
        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $pembelian = PembelianGym::find($id);

        return response()->json($pembelian);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
    //    
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $pembelian = PembelianGym::find($id)->update($request->all());

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $pembelian = PembelianGym::find($id)->delete();

        return response(null, 204);
    }
}
